## Cisco Secure Cloud Analytics for Private Network Monitoring

### Overview

- Extends public cloud monitoring architecture to provide visibility and threat detection for on-premises networks
- Delivered as a cloud-based SaaS solution

---

### Sensor Deployment and Data Collection

#### Secure Cloud Analytics Sensor

- Lightweight appliance deployed on a virtual machine or server
- Captures telemetry from native sources or extracts metadata from network packet flow

#### Data Transmission and Security

- Captured metadata is:
    - Encrypted and securely transmitted to the Secure Cloud Analytics platform
    - Stored and processed securely using:
        - TLS 1.2 encryption with ECDHE_RSA (P-256) and AES_256_GCM
        - Ephemeral keys for enhanced security
        - Encrypted storage at rest
- Only metadata is processed; packet payloads are neither stored nor transmitted

---

### Deployment Scenarios

- Sensors can be deployed in:
    
    - Enterprise networks
    - Private data centers
    - Branch offices
- Data collection methods:
    
    - Flow data (e.g., NetFlow, IPFIX)
    - Mirrored network traffic via SPAN port (from router or switch)
- Flow data can also be sent from:
    
    - Cisco Telemetry Broker
    - Secure Network Analytics (formerly Cisco Stealthwatch Enterprise)
    - Includes IPFIX and NetFlow packets

---

### Integration with Network Infrastructure

#### Catalyst 9000 Family Integration

- Integrates with Catalyst 9200/9300 Series Switches and Catalyst 9800 Series Wireless Controllers
- Enables seamless telemetry data transmission from branch/access layers to the Secure Cloud Analytics portal
- Supports robust threat detection and anomaly analysis
- No need for additional hardware or sensors

---

### Alerting Capabilities

- Sensors can deliver alerts from the cloud portal to local devices using:
    - Syslog
    - SNMP (Simple Network Management Protocol)
- Compatible with SIEM solutions for alert collection

---

### Integration with Cisco Solutions

#### Cisco Identity Services Engine (ISE)

- Integration via Cisco pxGrid
- Enables user attribution data retrieval (e.g., MAC address, domain, username)
- Enhances user activity reporting and visibility into all network users

#### Cisco Umbrella Investigate REST API

- Adds geolocation, detected domain names, and malicious domain data for external IPs

#### Meraki Dashboard REST API

- Provides hostname resolution and additional information within the Secure Cloud Analytics web interface
- Enhances visibility into hosts on the monitored network